#!/usr/bin/env python3

import subprocess
import os

# Change working dir to the script path
os.chdir(os.path.dirname(os.path.abspath(__file__)))

subprocess.run(['mcrl22lps', '-n', 'leader.mcrl2', 'leader.lps'], check=True)

subprocess.run(['lps2pbes', '-v', '-f', 'nodeadlock.mcf', 'leader.lps', 'leader.nodeadlock.pbes'], check=True)
subprocess.run(['pbes2bool', '-v', 'leader.nodeadlock.pbes'], check=True)

# This indicates the size of the non-reduces state space
subprocess.run(['lps2lts', '-v', 'leader.lps'], check=True)

# Find and eliminate the constants representing process id's
subprocess.run(['lpsconstelm', '-v', 'leader.lps', 'temp.lps'], check=True)

# Find confluent taus and rename these to ctau. The flag -o enables induction on
# lists, which is necessary to prove confluence
subprocess.run(['lpsconfcheck', '-o', '-t1', 'temp.lps', 'temp1.lps'], check=True)

# This shows the dramatically reduced statespace, generated by giving priority
# to ctaus.
subprocess.run(['lps2lts', '-vcctau', 'temp1.lps', 'temp1.lts'], check=True)
