// dzn-runtime -- Dezyne runtime library
//
// Copyright © 2016 Rutger van Beusekom <rutger@dezyne.org>
// Copyright © 2019, 2023 Jan Nieuwenhuizen <janneke@gnu.org>
// Copyright © 2018 Filip Toman <filip.toman@verum.com>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#ifndef DZN_META_H
#define DZN_META_H

#include <dzn/config.h>

#if DZN_TRACING
typedef struct dzn_meta dzn_meta;
struct dzn_meta
{
  char const *name;
  dzn_meta const *parent;
};
#endif /* DZN_TRACING */

typedef struct dzn_port_meta dzn_port_meta;
struct dzn_port_meta
{
  struct
  {
    void *component;
#if 1 //DZN_TRACING
    char const *name;
    dzn_meta const *meta;
#endif /* DZN_TRACING */
  } provides;
  struct
  {
    void *component;
#if 1 //DZN_TRACING
    char const *name;
    dzn_meta const *meta;
#endif /* DZN_TRACING */
  } requires;
};

#endif /* DZN_META_H */
//version: 2.19.2
//version: 2.19.2
