;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2020 Rob Wieringa <Rob.Wieringa@verum.com>
;;; Copyright © 2020,2021,2022 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2020 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (daemon Command_data2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport libenvelope)
  #:duplicates (merge-generics)
  #:export (<daemon:Command_data2event>
            .command_data2event))

(define-class <daemon:Command_data2event> (<dzn:component>)
  (command_data2event #:accessor .command_data2event #:init-form (make <daemon:Icommand_data2event>) #:init-keyword #:command_data2event))

(define-method (initialize (o <daemon:Command_data2event>) args)
  (next-method)
  (set! (.command_data2event o)
        (make <daemon:Icommand_data2event>
          #:in (make <daemon:Icommand_data2event.in>
                 #:name "command_data2event"
                 #:self o
                 #:wrap (lambda args
                          (call-in
                           o (lambda _
                               (apply command_data2event-wrap (cons o args)))
                           `(,(.command_data2event o) wrap)))
                 #:unwrap (lambda args
                            (call-in
                             o
                             (lambda _
                               (apply command_data2event-unwrap (cons o args)))
                             `(,(.command_data2event o) unwrap))))
          #:out (make <daemon:Icommand_data2event.out>))))

(define-method (command_data2event-wrap (o <daemon:Command_data2event>) label data)
  (action o .command_data2event .out .wrapped (libenvelope:wrap label data)))

(define-method (command_data2event-unwrap (o <daemon:Command_data2event>) data)
  (let ((label (libenvelope:label data))
        (data (libenvelope:data data)))
    (case label
      ((command) (action o .command_data2event .out .command data))
      ((wrapped) (action o .command_data2event .out .wrapped data))
      (else (stderr "Command_data2event: no such label: ~s\n" label)
            (action o .command_data2event .out .error)))))
