;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2019 Rob Wieringa <Rob.Wieringa@verum.com>
;;; Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (daemon View_data2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport libenvelope)
  #:duplicates (merge-generics)
  #:export (<daemon:View_data2event>
            .view_data2event))

(define-class <daemon:View_data2event> (<dzn:component>)
  (view_data2event #:accessor .view_data2event #:init-form (make <daemon:Iview_data2event>) #:init-keyword #:view_data2event))

(define-method (initialize (o <daemon:View_data2event>) args)
  (next-method)
  (set! (.view_data2event o)
        (make <daemon:Iview_data2event>
          #:in (make <daemon:Iview_data2event.in>
                 #:name "view_data2event"
                 #:self o
                 #:wrap (lambda args
                          (call-in
                           o
                           (lambda _
                             (apply view_data2event-wrap (cons o args)))
                           `(,(.view_data2event o) wrap)))
                 #:unwrap (lambda args
                            (call-in
                             o
                             (lambda _
                               (apply view_data2event-unwrap (cons o args)))
                             `(,(.view_data2event o) unwrap))))
          #:out (make <daemon:Iview_data2event.out>))))

(define-method (view_data2event-wrap (o <daemon:View_data2event>) label data)
  (action o .view_data2event .out .wrapped (libenvelope:wrap label data)))

(define-method (view_data2event-unwrap (o <daemon:View_data2event>) data)
  (let ((label (libenvelope:label data))
        (data (libenvelope:data data)))
    (case label
      ((back) (action o .view_data2event .out .back))
      ((event) (action o .view_data2event .out .event data))
      ((index_selected) (action o .view_data2event .out .index_selected data))
      ((request) (action o .view_data2event .out .request data))
      ((selected) (action o .view_data2event .out .selected data))
      ((wrapped) (action o .view_data2event .out .wrapped data))
      (else (stderr "View_view_data2event: no such label: ~s\n" label)
            (action o .view_data2event .out .error)))))
