;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2019,2020,2021 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (transport libtransport)
  #:use-module (ide util)
  #:use-module (ide json)
  #:duplicates (merge-generics)
  #:export (libtransport:serialize
            libtransport:unserialize))

(define (libtransport:serialize o)
  (catch #t
    (lambda _ (scm->json-string o))
    (handle-json-error o)))

(define (libtransport:unserialize o)
  (catch #t
    (lambda _
      (json-string->alist-scm o))
    (handle-json-error o)))
